IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[CP_CD_ES_Rpt_Global_Ult_Accesos]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [dbo].[CP_CD_ES_Rpt_Global_Ult_Accesos]
END
GO

CREATE PROCEDURE [dbo].[CP_CD_ES_Rpt_Global_Ult_Accesos] @pCantUltRegistros INT
AS

CREATE TABLE #rUlt_Accesos_Global
(Id_ES			INT, 
Fecha			VARCHAR(10), 
Hora			VARCHAR(10), 
Tipo			VARCHAR(1), 
Id_Tarjeta		VARCHAR(50), 
Id_Cliente		INT,
Razon_Social	VARCHAR(100),
Resultado		VARCHAR(1),
Observacion		VARCHAR(8000),
Id_Controlador	SMALLINT,
Controlador		VARCHAR(20), 
Id_Acceso		SMALLINT,
Acceso			VARCHAR(20))

INSERT INTO #rUlt_Accesos_Global
SELECT 
TOP 10
CE.Id_ES,
CONVERT(VARCHAR(10), CE.Fecha, 102) AS Fecha,
CONVERT(VARCHAR(10), CE.Fecha, 108) AS Hora,
CE.Tipo,
CE.Id_Tarjeta, 
CE.Id_Cliente,
CL.Razon_Social,
CE.Resultado,
CONVERT(VARCHAR(8000), CE.Observacion),
CE.Id_Controlador,
SUBSTRING(CC.Descripcion, 1, 20) AS Controlador, 
CE.Id_Acceso,
CA.Descripcion AS Acceso
FROM CD_ES CE, Clientes CL, CD_Controladores CC, CD_Accesos CA
WHERE
CE.Id_Cliente  = CL.Id_Cliente
AND CE.Id_Controlador = CC.Id_Controlador
AND CE.Id_Acceso = CA.Id_Acceso
AND CONVERT(DATE, CE.Fecha) = CONVERT(DATE, GETDATE())
ORDER BY CE.Id_ES DESC


SELECT * FROM #rUlt_Accesos_Global

DROP TABLE #rUlt_Accesos_Global
